class consul::logrotate inherits consul {
  if $hourly_logrotate {
    logrotate::rule { 'consul':
      ensure          => present,
      path            => '/var/log/jtv/consul.log',
      missingok       => true,
      olddir          => '/var/log/archive/',
      rotate          => 7,
      rotate_every    => 'hourly',
      sharedscripts   => true,
      create          => false,
      compress        => true,
      compresscmd     => '/usr/bin/pbzip2',
      compressoptions => '-1p4',
      compressext     => '.bz2',
      postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
      size            => '500M'
    }
  }
}
