# Configures nagios checks for a consul leader.
#
class consul::monitoring inherits consul {
  $active_commands = {
    'consul remote tcp_8300' => {
      command  => 'check_tcp!8300',
      options  => {
        retry_interval => 1,
      },
    },
  }

  $check_commands = {
    'consul pop members check' => {
      command => 'check_consul_member.py',
    },
    'consul check pop' => {
      command => 'check_consul_self_pop.py',
    },
    'consul master' => {
      command => 'consul-alert-server',
    },
    'check_consul_server_dns' => {
        command => "check_consul_server_dns.sh -H ${::fqdn} -P ${::pop}"
    },
  }
  if pick($twitch_environment, $::twitch_environment) == 'production' {
    create_resources(twitch_servicecheck::passive, $check_commands)
    create_resources(twitch_servicecheck::active, $active_commands)
  }
}
