class consul::nginx inherits consul {
  if $consul::ui_enabled {
    if $consul::use_ssl {
      $cert_file         = '/etc/ssl/certs/wildcard_internal_justin_tv.pem'
      $key_file          = '/etc/ssl/private/wildcard_internal_justin_tv.key'

      # Sandstorm bucket video/ssl_keys/production/wildcard_internal_justin_tv/pem
      # contains pem of cert for *.internal.justin.tv + intermediate
      $wildcard_jtv_cert = '{{ key "video/ssl_keys/production/wildcard_internal_justin_tv/pem" }}'
      $wildcard_jtv_key  = '{{ key "video/ssl_keys/production/wildcard_internal_justin_tv/key" }}'

      twitch_ssl_certificate::certificate { 'wildcard-jtv-cert':
        cert_filesystem_path => $cert_file,
        cert_contents        => $wildcard_jtv_cert,
        cert_restart_cmd     => '/usr/sbin/service nginx reload',
        key_identifier       => 'wildcard-jtv-key',
        key_filesystem_path  => $key_file,
        key_contents         => $wildcard_jtv_key,
        key_restart_cmd      => '/usr/sbin/service nginx reload',
        before               => Twitch_nginx::Vhost['consul'],
      }
    }
    ::twitch_nginx::vhost{ 'consul':
      content => template('consul/nginx.conf.erb'),
    }
  }
}
