class consul::params {
  $bind                          = '0.0.0.0'
  $interface                     = $::default_gateway_interface
  $config_dir                    = '/etc/consul.d'
  $scripts_data_dir              = '/etc/consul'
  $deb_version                   = '1.9.3-7'
  $data_dir                      = '/var/lib/consul'
  # we need to use hiera() call on the line below since $datacenter is used in metrics prefixes
  $datacenter                    = hiera('consul::datacenter', $::pop)
  $disable_remote_exec           = true
  $disable_update_check          = true
  $dns_name                      = 'consul.internal.justin.tv'
  # for compatability reasons we honor provisioning wishes with inverting the
  # meaning of the disable_consul fact, we use it to keep the service turned off.
  $enable                        = pick(!$::disable_consul, true)
  $group                         = 'nogroup'
  $join                          = []
  $join_wan                      = []
  $join_wan_ignore               = []
  $syslog                        = true
  $syslog_facility               = 'local3'
  $log_level                     = 'ERR'
  $ui_enabled                    = false
  $user                          = 'nobody'
  $version                       = undef
  $reconnect_timeout             = '8h'
  $statsd_addr                   = hiera('graphite_server', 'statsd.internal.justin.tv')
  $server_metrics_prefix         = "consul.${datacenter}.${hostname}"
  $client_metrics_prefix         = "consul.${datacenter}"
  $raft_multiplier               = hiera('consul_raft_multipler',5)
  $hourly_logrotate              = false
  $anycast_ip                    = undef
  $bgp_community                 = undef
  $use_ssl                       = false
  $systemd_restart               = 'on-failure'

  $leave_on_exit = $::ec2_instance_id ? {
    undef   => false,
    default => undef,
  }

  # We should always hard code the hostname in the config file, that way a
  # rename of the box causes puppet to HUP consul. In addition the regex
  # below will allow us to support multi-part hostnames:
  # Examples:
  # * puppet1.justin.tv
  # * puppet1.pop01.justin.tv
  # * puppet1.staging.pop01.justin.tv
  $regex     = "(\\.${::pop}|\\.justin\\.tv|\\.twitch\\.tv|\\.twitchtv\\.com)"
  $node_name = regsubst($::fqdn, $regex, '', 'G')
}
