class consul::setup inherits consul {
  file { '/etc/default/consul':
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    content => template("${module_name}/default.erb"),
    notify  => Service['consul'],
  }

  file { $config_dir:
    ensure  => directory,
    mode    => '0755',
    owner   => 'root',
    group   => 'root',
    recurse => true,
    purge   => true,
    notify  => Class['::consul::reload_service'],
  }

  file { $data_dir:
    ensure  => directory,
    mode    => '0755',
    owner   => $user,
    group   => $group,
  }

  file { '/etc/dhcp/dhclient-enter-hooks.d/consul-dhclient-hook':
    ensure  => file,
    mode    => '0644',
    content => template('consul/consul-dhclient-hook.erb'),
  }

  package { 'dta-consul':
    ensure => $deb_version,
    notify => Service['consul'],
  }
}
