# consul-template puppet module

This module provides the consul_template::service resource.  This will ensure consul-template is installed and configure it to create a file based on a the template definition you provide.

## Customizing

Use the following hiera values to customize this module:

|Hiera Value |Type |Description|
|------------|-----|-----------|
|consul_template::consul_addr | string | consul client/server to query|
|consul_template::wait | string | max amount of time to wait before rendering template. Must be in the form: `'<min>s:<max>s'`|
|consul_template::max_stale | string | max interval to allow stale data|
|consul_template::retry | string | time to wait before retrying consul connection. only used for legacy version|
|consul_template::backoff | string | base amount of time to sleep between retry attempts|
|consul_template::max_backoff | string | max ammount of time to sleep between retry attempts|
|consul_template::version | string | version of consul-template to use|
|consul_template::loglevel | string | consul template log level|
|consul_template::package_name | string | Name of the OS consul-template package
|consul_template::dedup_enabled | boolean | set to true to use de-duplication mode|

IMPORTANT: When customizing the value of consul_template::wait, be sure the value is in the form: `'<min>s:<max>s'`.  For example, if you want a minimum of 30 seconds and maximum of 120 seconds, use: `'30s:120s'`.

NOTE: To maintain backward compatibility, this module installs an older version of consul-template and defaults to not using de-dup mode.  If you'd like to use newer versions of consul-template and de-dup mode, set the following hiera values:
```
consul_template::package_name: 'dta-consul-template'
consul_template::version: '0.19.4-1'
consul_template::dedup_enabled: true
```

## Example

```puppet
class mytest {
  file { '/etc/mytest':
    ensure => directory,
    mode => '0755',
  }

  file { '/etc/mytest/test.sh':
    ensure => 'present',
    mode => '0755',
    source => 'puppet:///modules/mytest/test.sh',
  }

  file { '/etc/mytest/test.conf.ctmpl':
    ensure => 'present',
    mode => '0644',
    source => 'puppet:///modules/mytest/test.conf.ctmpl',
  }

  consul_template::service{ 'mytest':
    source => '/etc/mytest/test.conf.ctmpl',
    destination => '/etc/mytest/test.conf',
    command => '/etc/mytest/test.sh',
  }
}
```
