#!/bin/bash
set -e -u -o pipefail
output=$(consul-template \
  -once \
  -syslog \
  -syslog-facility=local3 \
  -log-level=INFO \
  -dry \
  -consul-retry-attempts=1 \
  -retry=3s \
  "$@" || exit 0)

# return 0 if output is zero length
test -z "$output"
