class consul_template::params {
  $ensure          = 'present'
  $config_file     = '/etc/consul-template.conf'
  $consul_addr     = 'localhost:8500'
  # consul-template wait option syntax. Value should be in the form: '<min>s:<max>s'
  $wait            = '15s:60s'
  $max_stale       = '30s'
  # retry is used when consul-template version <= 0.19.0
  $retry           = '15s'
  # backoff and max_backoff are used when consul-template version >=0.19.0
  $backoff         = '1s'
  $max_backoff     = '2m'
  $version         = $::lsbdistcodename ? { 'xenial' => '0.19.5-1', 'bionic' => '0.20.0-1' }
  $consul_loglevel = 'WARN'
  $package_name    = 'dta-consul-template'
  $dedup_enabled   = true
}
