# control-repo
Puppet Control Repo

## Overview

This repository contains the top-level configs for each Puppet environment. Creating a branch here enables an environment with the name of the branch, and will (unless the Puppetfile is edited) pull in the branch on other module repos having a branch with the same name. If a module repo is specified in Puppetfile that does not have a matching branch, it will default to the 'master' branch of that repo.

You likely do NOT need to PR or merge anything here. This repo only controls environments, you should very rarely want or need to update the configuration of the production environment. See the Wiki for more info here https://wiki.twitch.com/display/VID/R10k+Puppet-master+migration+2020 and here https://wiki.twitch.com/display/VID/R10K.

## Video Puppet Repositories Best Practices

The following describes the scaffolding this repository has been configured with that should be applied to all repositories in the video-puppet organization

### CODEOWNERS

The CODEOWNERS file is a configuration file that associates filename regexes with github users who "own" the file. When this file is configured, any pull request opened that includes changes to files that match the regex to user mapping will automatically be requested for a review.

To see an example of a CODEOWNERS file, please refer to the CODEOWNERS file in this repository.

more info on: https://github.blog/2017-07-06-introducing-code-owners/

### Branch Naming

A more detailed guide for branch naming will be documented here once we start relying more on static R10k based environments. Because this is Puppet and Puppet does not work with hyphenated branches, the **HARD REQUIREMENT** is that NO branch contain a hyphen '-' (use underscore '\_' instead). Since this repo only exists for creating and maintaining Puppet environments, there is no good reason for any exception to this rule. There is a protected branch filter that should reject any attempt to push an improperly named branch.

### Protected Branches

Protected branches is a feature that allows users to create rules on a specific branch, all branches, or any regex-matched branch for a given repository. In a puppet context, this allows each branch (environment) of a module to have different requirements depending on the owner of that branch.

For example, if the video-rep team and ingest teams both consume a redis repository but require different versions, branch protection rules with correct ownership settings can prevent a video-rep employee from submitting/pushing a PR to the ingest branch without approval.

This repo is configured to apply branch protection requiring CODEOWNERS to review before pushing to the production branch. As more static environments are setup to rely on Puppetfile, they will be added to the protection list.

more info on: https://help.github.com/en/articles/about-protected-branches
