# Puppet

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Getting Started](#getting-started)
  - [Pre-commit hook](#pre-commit-hook)
- [Usage](#usage)
- [Testing with Vagrant](#testing-with-vagrant)
  - [Customizing Vagrant Environment](#customizing-vagrant-environment)
    - [Using more than one `settings.yaml` file](#using-more-than-one-settingsyaml-file)
  - [VM Configuration](#vm-configuration)
    - [Using NFS for improved puppet compilation time](#using-nfs-for-improved-puppet-compilation-time)
- [Rake Tasks](#rake-tasks)
- [Modules](#modules)
  - [Installing Modules](#installing-modules)
- [Updating Puppet Nodes](#updating-puppet-nodes)
  - [Single Node Updates](#single-node-updates)
  - [Multiple Node Updates](#multiple-node-updates)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Getting Started
*Note: This doc is old/being updated from Systems Puppet. Check with VIDCS if Unsure about something*

[Puppet](https://puppetlabs.com/puppet/puppet-open-source) is our primary
configuration management system at Twitch.

If you haven't used Puppet before, you may want to have a look at the
documentation [here](https://docs.puppetlabs.com/puppet/).

Always run puppet-lint on your code before you submit a PR, while some of the
style guidelines appear arbitrary, they can actually have a big impact on performance.

Changes to core/twitch_core effect EVERY node and should be heavily reviewed and tested.

### Pre-commit hook

Install a pre-commit hook to help you validate and lint your code on each commit.

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Setup ruby in your environment. Known working ruby version: `2.3.7`
  * To manage ruby versions easily on your machine, setup [`rbenv`](https://github.com/rbenv/rbenv#installation)
  * There is a known issue that the `pre-commit` does not respect the ruby version set by `rbenv`. To get around this issue:
    * You only need to do this once.
    ```bash
    rbenv_previous_global_version=$(rbenv global)
    rbenv global 2.3.7
    # Default puppet 3.x does not work well in ruby environment. 4.10.x provides parity, without the ruby pain
    gem install puppet -v 4.10.0
    pre-commit install --install-hooks
    rbenv global "$rbenv_previous_global_version"
    ```

Run `pre-commit install --install-hooks` to install `pre-commit` hook.

## Usage
See [the wiki](https://wiki.twitch.com/display/VID/Puppet+Usage+Guidance+-+Video+Platform) for detailed information about
using puppet on your service, and [another wiki page](https://wiki.twitch.com/display/VID/R10k+Puppet-master+migration+2020)
about branch testing with control-repo.

## Testing with Vagrant

[Vagrant](http://www.vagrantup.com/) can be used to create virtual machines
which act as test nodes for Puppet changes. If you'd like to introduce a change
to a module, you can test that change in Vagrant before opening a pull request.

We already have a `Vagrantfile` in this repository. To get started with Vagrant
testing, you can run:

    vagrant up
    vagrant up xenial

### Customizing Vagrant Environment

This repo ships with a `settings.yaml.example` file. It is only an example file
and **it needs to be copied to `settings.yaml` in your own repo.** Missing this
step will likely result in a broken Vagrant; puppet and/or apt will fail to work.

This file is used to customize your local Vagrant configuration for Puppet. You
can dynamically create as many vagrant boxes as your system can handle, and
configure each one independently without editing the `Vagrantfile`.

The default box image is Ubuntu 12.04 from Hashicorp (`hashicorp/precise64`).

You can use the `settings.yaml` file to test modules or classes. Once you have
modules you want to use all you need to do is specify their class names in your
`settings.yaml`:

```yaml
classes:
  - core
  - twitch
  - my_service
```

Vagrant will read the `classes` key for an array of class names to use on the
box when you run `vagrant up` be sure to run `vagrant provision` if you change
this file after running `vagrant up`.

#### Using more than one `settings.yaml` file

If you find that you need to bring up multiple VMs with different
`settings.yaml` configurations (e.g. launch 2 different VM's with different
puppet class lists), you can make multiple YAML files and place them in the
`vagrant_settings` directory. Then, define a function like:

`make_vms () { SETTINGS_FILE="vagrant_settings/$2.yaml" vagrant $1 }`

which can be used like `make_vms [up|provision|etc...] SETTINGS_FILE_NAME`

You do not need to use this, and directly calling `vagrant` will just use
the usual `settings.yaml` file.

### VM Configuration

In `settings.yaml` you can create your own boxes:

```yaml
vagrant_boxes:
  precise:
    memory: 1024
```

This defines a box named `precise` using default settings, but sets the memory
to `1g`. Read the `settings.yaml.example` file for more details.

#### Using NFS for improved puppet compilation time

Virtualbox's `vboxsf` (default) shared folder I/O performance is slow. To improve puppet compilation time, [NFS](https://www.vagrantup.com/docs/provisioning/puppet_apply.html#synced_folder_type) can be used instead of vagrant's `vboxsf`.

The following prerequisites must be setup before NFS can be used:

* Ensure host firewall is not blocking incoming connections from host-only network.
  * On OSX (AMZN managed):
    ```bash
    # Find first VirtualBox hostonly network
    vboxname="$(VBoxManage list hostonlyifs | grep -E ^Name | awk '{print $NF}' | head -n 1)"
    if [[ -n "$vboxname" ]]; then
      echo "set skip on ${vboxname}" | sudo tee -a /usr/local/amazon/var/quarantine/template-com.amazon.custom
    fi
    ```

* Update `settings.yaml` to include:
  ```yaml
  synced_folder_type: nfs
  ```

## Rake Tasks

There are some handy `rake` tasks that exist in `tasks/`, a few of them:

Command                 | Description
---                     | ---
`rake test`             | Validate All Manifests with `puppet parser validate`
`rake module:check_all` | Check all modules against their `metadata.json` file
`rake module:new[foo]`  | Create a new Puppet module skeleton in `modules/foo`

## Modules

### Installing Modules

In order to correctly install and version the modules provided from the [Puppet
Forge](https://forge.puppetlabs.com/), you will need to use the `puppet module`
command.

  * `puppet module install --modulepath=modules puppetlabs-mysql --version
     X.X.X`

To configure puppet to always look in the correct directory on your system, you
may create/edit `~/.puppet/puppet.conf` to have the following config:

    [main]
    modulepath=PATH_TO_THIS_PUPPET_REPO/modules

As we move towards more R10k implementation, please study up on how Puppetfile can be leveraged to specify modules. We will likely
mirror external repos on artifactory (or similar) rather than allow direct Puppetfile module pulls, but we will NOT allow editing
of 3rd party provided modules without significant need. See best-practices about writing wrappers to handle most of what you want
to do instead of a direct edit.

## Updating Puppet Nodes

After your initial puppet run, it is inevitable that you'll need to run puppet again to update core modules, or service specific dependencies.

### Single Node Updates

This is as simple as ssh'ing onto the node and running:

```bash
$ sudo puppet agent --test
```

or

```bash
$ sudo puppet agent -t -v
```

"test" here means "Run the agent once, do not daemonize, log output to STDOUT. If --test (-t) is omitted, the agent will daemonize, and runs will fail because "puppet is already running".

### Multiple Node Updates

* Find dependent puppet nodes by ssh'ing onto a puppet-master(found in [consul](http://consul.internal.justin.tv/ui/dist/#/us-west2/nodes?filter=puppet-master)) and running a [puppet db query](https://github.com/dalen/puppet-puppetdbquery#query-examples). Here's an example:

```bash
sudo puppet query nodes '(class["<your_puppet_module>"])'
```

* Use [pssh](http://linux.die.net/man/1/pssh) to update puppet across the identified hosts:

```bash
pssh -H "host1 host2 ..." -i -A -O StrictHostKeyChecking=no sudo puppet agent --test --tags=<your_class>
```

Note: For the pssh step, if nothing appears to be happening ensure <your_class> begins with a capital letter: `--tags=Twitch_sandstorm_agent`
