# Do not add new clusters to this file. Set the following facts correctly:
# - twitch_role
# - twitch_environment

####################################################
############# DEFAULT PUPPET EXEC PATH #############
####################################################

Exec { path => ['/bin', '/sbin', '/usr/bin', '/usr/sbin', '/usr/local/bin', '/usr/local/sbin'] }


########################################################
############# DEFAULT ASSET CLASSIFICATION #############
########################################################

node default {
  if $facts['twitch_role'] != undef {
    $cluster = $facts['twitch_role']
  } elsif $facts['ec2_user_data_cluster'] != undef {
    $cluster = $facts['ec2_user_data_cluster']
  } else {
    $cluster = 'unclassified'
  }
  if $facts['twitch_environment'] != undef {
    $twitch_environment = $facts['twitch_environment']
  } elsif $facts['ec2_user_data_twitch_environment'] != undef {
    $twitch_environment = $facts['ec2_user_data_twitch_environment']
  } else {
    $twitch_environment = 'production'
  }
  # This allows manifests to determine they're using omnibus (on Xenial).
  $omnibus_puppet = $::gemhome ? {
    '/opt/omnibus-puppet/' => true,
    default                => false,
  }
  hiera_include('classes')
}


##########################################################
############# AWS INSTANCES' CLASSIFICATIONS #############
##########################################################

# Load cluster and classes from user data if running in AWS.
# User-data is missing? Add it with your deployment.
# Facts belong in /etc/facter/facts.d on most OSes.

node /.*us-west2.justin.tv/, /.*us-west-2.compute.internal/,
  /.*us-east-1.justin.tv/, /.*us-east-1.compute.internal/,
  /.*us-east-2.justin.tv/, /.*us-east-2.compute.internal/,
  /.*eu-west-1.justin.tv/, /.*eu-west-1.compute.internal/,
  /.*ap-southeast-1.justin.tv/, /.*ap-southeast-1.compute.internal/ {
  if $ec2_user_data_cluster != undef {
    $cluster = $ec2_user_data_cluster
  }
  if $ec2_user_data_twitch_environment != undef {
    $twitch_environment = $ec2_user_data_twitch_environment
  }
  hiera_include('classes')
}


###########################################################
############# BARE METAL HOST CLASSIFICATIONS #############
###########################################################

# DO NOT ADD THINGS HERE. Remove them. The default node classification above
# handles all new bare metal servers, and their addition below is no longer required.


node /^pxe-config-.*/, /^provisioner/ {
  $cluster = 'provisioner'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-almanac-lb-[0-9a-f]{6}/ {
  $cluster = 'video-almanac-lb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-rabbit-hls-[0-9a-f]{6}/ {
  $cluster = 'video-rabbit-hls'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-rabbit-staging-[0-9a-f]{6}/ {
  $cluster = 'video-rabbit-staging'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^reptesting\d+/, /^video-reptesting-[0-9a-f]{6}/{
  $cluster = 'reptesting'
  $twitch_environment = 'reptesting'
  hiera_include('classes')
}
node /^video[0-9]{1,2}\./, /^video-pr-[0-9a-f]{6}/ {
  $cluster = 'video-pr'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-pr-staging-[0-9a-f]{6}/ {
  $cluster = 'video-pr'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-edge-[0-9a-f]{6}/ {
  $cluster = 'video-edge'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^video-edge-staging-[0-9a-f]{6}/ {
  $cluster = 'video-edge'
  $twitch_environment = 'staging'
  hiera_include('classes')
}

node /^video-offnet-origin-[0-9a-f]{6}/ {
  $cluster = 'video-offnet-origin'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^video-service-ext-[0-9a-f]{6}/ {
  $cluster = 'video-service-ext'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^video-service-ext-staging-[0-9a-f]{6}/ {
  $cluster = 'video-service-ext'
  $twitch_environment = 'staging'
  hiera_include('classes')
}

node /^video-service-int-[0-9a-f]{6}/ {
  $cluster = 'video-service-int'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^video-service-int-staging-[0-9a-f]{6}/ {
  $cluster = 'video-service-int'
  $twitch_environment = 'staging'
  hiera_include('classes')
}

node /^ingest-staging-[a-f0-9]{6}/ {
  $cluster = 'ingest'
  $twitch_environment = 'staging'
  hiera_include('classes')
}

node /^ingest-proxy-edge-staging-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy-edge'
  $twitch_environment = 'staging'
  hiera_include('classes')
}

node /^ingest-canary-[a-f0-9]{6}/ {
  $cluster = 'ingest'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^ingest\d+/, /^ingest-[a-f0-9]{6}/ {
  $cluster = 'ingest'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^transcode-ev-[a-f0-9]{6}/ {
  $cluster = 'transcode-ev'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^transcode-x2-[a-f0-9]{6}/ {
  $cluster = 'transcode-x2'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^transcode-x2-canary-[a-f0-9]{6}/ {
  $cluster = 'transcode-x2-canary'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^transcode-vp9-[a-f0-9]{6}/ {
  $cluster = 'transcode-vp9'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^transcode-vp9-staging-[a-f0-9]{6}/ {
  $cluster = 'transcode-vp9'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-origin-staging-[a-f0-9]{6}\./ {
  $cluster = 'video-origin'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-origin-canary-[a-f0-9]{6}\./ {
  $cluster = 'video-origin'
  $twitch_environment = 'canary'
  hiera_include('classes')
}
node /^video-tier1-[a-f0-9]{6}/ {
  $cluster = 'video-tier1'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-tier1-staging-[a-f0-9]{6}/ {
  $cluster = 'video-tier1'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-tier1-canary-[a-f0-9]{6}/ {
  $cluster = 'video-tier1'
  $twitch_environment = 'canary'
  hiera_include('classes')
}
# frontier overrides will be removed once the rollout is complete ING-8571
node /^frontier-canary-[a-f0-9]{6}/ {
  $cluster = 'frontier'
  $twitch_environment = 'canary'
  hiera_include('classes')
}
node /^video-daemons-prod-[a-f0-9]{6}\./ {
  $cluster = 'video-daemons-prod'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-daemons-staging-[a-f0-9]{6}\./ {
  $cluster = 'video-daemons-staging'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^usher\d+\.staging/ {
  $cluster = 'usher'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^usher-mmr-lb-[0-9a-f]{6}/ {
  $cluster = 'usher-mmr-lb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher\d+\./, /^usher-[a-f0-9]{6}\./, /^usher-(canary|staging|benchmark)-[a-f0-9]{6}\./ {
  $cluster = 'usher'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-api-lb-[a-f0-9]{6}\./ {
  $cluster = 'video-api-lb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-api-[a-f0-9]{6}\./ {
  $cluster = 'video-api'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-api-staging-[a-f0-9]{6}\./ {
  $cluster = 'video-api'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^usher-pgbouncer-[0-9a-f]{6}/ {
  $cluster = 'usher-pgbouncer'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher-pgbouncer-staging-[0-9a-f]{6}/ {
  $cluster = 'usher-pgbouncer'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^mail\d+/, /^mail-.*/ {
  $cluster = 'mail'
  $twitch_environment = 'production'
  hiera_include('classes')
}

node /^usherdb-[a-z0-9]+/ {
  $cluster = 'networkdb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher-postgres-[0-9a-f]{6}/ {
  $cluster = 'usher-postgres'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher-postgres-staging-[0-9a-f]{6}/ {
  $cluster = 'usher-postgres'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^puppet-master-[a-f0-9]{6}/, /^puppet-ca-[a-f0-9]{6}/ {
  $cluster = 'puppet-master'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^cdncache\d+/ {
  $cluster = 'cdncache'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-cdncache-[a-f0-9]{6}/ {
  $cluster = 'video-cdncache'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-networkdb-[a-f0-9]{6}/ {
  $cluster = 'networkdb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^trace-agg-/ {
  $cluster = 'trace_aggregator'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^trace-api-/ {
  $cluster = 'trace_api'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^trace-collect-/ {
  $cluster = 'trace_collector'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^trace-statsdsink-/ {
  $cluster = 'trace_statsdsink'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^netrr\d+/, /^netrr-[a-f0-9]{6}/ {
  $cluster = 'netrr'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^offnet-netrr-[a-f0-9]{6}/ {
  $cluster = 'offnet-netrr'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^consul\d+/ {
  $cluster = 'consul-server'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^consul-wanmaster-[a-f0-9]{6}/ {
  $cluster = 'consul-wanmaster'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^auditor-[a-f0-9]{6}/ {
  $cluster = 'auditor'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^globalviewcount-[a-f0-9]{6}/, /^globalviewcount-prev-prod-[a-f0-9]{6}/ {
  $cluster = 'globalviewcount'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^globalviewcount-staging-/ {
  $cluster = 'globalviewcount'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^s3-http-proxy-[a-f0-9]{6}/ {
  $cluster = 's3-http-proxy'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^ingest-proxy-hidden-\d+/,/^ingest-proxy-hidden-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy-hidden'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^ingest-proxy-edge-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy-edge'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^ingest-proxy-edge-priv-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy-edge-priv'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^ingest-proxy-lb-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy-lb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^ingest-proxy-\d+/,/^ingest-proxy-[a-f0-9]{6}/ {
  $cluster = 'ingest-proxy'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^smtp-relay-[a-f0-9]{6}/ {
  $cluster = 'smtp-relay'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^net-netrr-dev-\d+/, /^netrr-dev-\d+-.*/ {
  $cluster = 'netrr_dev'
  $twitch_environment = 'dev'
  hiera_include('classes')
}
node /^usher-postgres-\d{3}\.staging\.sfo01\.justin\.tv$/ {
  $cluster = 'usher-postgres'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^postfix-[a-f0-9]{6}/ {
  $cluster = 'postfix'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-thruk-[a-f0-9]{6}/ {
  $cluster = 'video-thruk'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-nagios-[a-f0-9]{6}/ {
  $cluster = 'video-nagios'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-nagios-staging-[a-f0-9]{6}/ {
  $cluster = 'video-nagios'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^openvpnas/ {
  $cluster = 'openvpnas'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^openvpn-/ {
  $cluster = 'openvpn'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^(pop-master-[ab])-[a-f0-9]{6}/ {
  $cluster = $1
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^pop-master-development-[a-f0-9]{6}/ {
  $cluster = 'pop-master'
  $twitch_environment = 'development'
  hiera_include('classes')
}
node /^pop-master-(test|staging)-[a-f0-9]{6}/ {
  $cluster = 'pop-master-xenial'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^dns-auth-dev-[a-f0-9]{6}/ {
  $cluster = 'dns-auth'
  $twitch_environment = 'development'
  hiera_include('classes')
}
node /^ipmi-services/ {
  $cluster = 'ipmi-services'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^squid-proxy-[a-f0-9]{6}/ {
  $cluster = 'squid-proxy'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^netjob1-[a-f0-9]{6}/ {
  $cluster = 'netjob1'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^netjump1-[a-f0-9]{6}/ {
  $cluster = 'netjump1'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^eve-ng-[a-f0-9]{6}/ {
  $cluster = 'eve-ng'
  $twitch_environment = 'development'
  hiera_include('classes')
}
node /^package-repo-/ {
  $cluster = 'package-repo'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^sgauge-reservoir-pool-a-staging-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-a'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^sgauge-reservoir-pool-b-staging-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-b'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^sgauge-reservoir-pool-a-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-a'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^sgauge-reservoir-benchmark-a-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-a'
  $twitch_environment = 'production-benchmark'
  hiera_include('classes')
}
node /^sgauge-reservoir-pool-b-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-b'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^sgauge-reservoir-benchmark-b-[a-f0-9]{6}/ {
  $cluster = 'sgauge-reservoir-pool-b'
  $twitch_environment = 'production-benchmark'
  hiera_include('classes')
}
# For bare metal consul servers.
node /^consul-(master-)?[a-f0-9]{6}/ {
  $cluster = 'consul-master'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-devops-performance-[a-f0-9]{6}/ {
  $cluster = 'video-devops-performance'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-ops-[a-f0-9]{6}/ {
  $cluster = 'video-ops'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher-memcached-[a-f0-9]{6}/ {
  $cluster = 'usher-memcached'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^usher-memcached-staging-[a-f0-9]{6}/ {
  $cluster = 'usher-memcached'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-weaver-[a-f0-9]{6}/ {
  $cluster = 'video-weaver'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-weaver-staging-[a-f0-9]{6}/ {
  $cluster = 'video-weaver'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
node /^video-weaver-lb-[a-f0-9]{6}/ {
  $cluster = 'video-weaver-lb'
  $twitch_environment = 'production'
  hiera_include('classes')
}
node /^video-weaver-lb-staging-[a-f0-9]{6}/ {
  $cluster = 'video-weaver-lb'
  $twitch_environment = 'staging'
  hiera_include('classes')
}
