#!/usr/bin/env python
import json
import logging, logging.handlers
import sys, os

level = logging.INFO
facility = logging.handlers.SysLogHandler.LOG_LOCAL5

logging.basicConfig(filename="/dev/null", level=level)
logger = logging.getLogger()
handler = logging.handlers.SysLogHandler(facility=facility)
handler.setFormatter(logging.Formatter('localhost bash_history %(message)s'))
logger.addHandler(handler)

for line in sys.stdin:
    logline = {
        'uid': os.getuid(),
        'gid': os.getgid(),
        'user': os.environ.get('USER'),
        'from': os.environ.get('SSH_CLIENT', 'Uknown').split()[0],
        'cmdline': line.strip(),
    }

    logger.info(json.dumps(logline))
