# dhcp.rb
# checks to see if dhcp is enabled on the host
require 'facter'

# Find primary interface
interface = Facter.value('default_gateway_interface')
# Location of dhclient pid file for primary interface
dhclient_pid  = "/run/dhclient.#{interface}.pid"

Facter.add('dhcp_enabled') do
  if File.exists?(dhclient_pid)
    setcode { true }
  else
    setcode { false }
  end
end
