Facter.value(:interfaces).split(',').each do |interface|

  interface_name = interface.sub('_',':')

  if Facter::Util::Resolution.which('ethtool')
    permanent_macaddress = Facter::Util::Resolution.exec("/sbin/ethtool -P #{interface_name} 2>/dev/null").split(': ').last
  end

  next if permanent_macaddress == '00:00:00:00:00:00'
  Facter.add("permanent_macaddress_#{interface}") do
    confine { Facter::Util::Resolution.which('ethtool') }
    setcode do
      permanent_macaddress
    end
  end
end
