#
# return list of physical interfaces
# enp1s0f0,enp1s0f1,enp4s0
physical_interfaces = []
Facter.add(:physical_interfaces) do
  confine :kernel => 'Linux'
  Dir.glob("/sys/class/net/*").each do |file|
    interface = File.readlink(file)
    if !interface["virtual"]
      physical_interfaces << File.basename(interface)
    end
  end
  setcode do
    physical_interfaces.uniq.sort.join(',')
  end
end
