require 'facter/util/file_read'

ssd_disks = []
hdd_disks = []
raid_disks = []
multiple_queue_devices = []
Facter.value('blockdevices').split(',').each do |disk|
  # look up if driver reports a rotational disk
  file = "/sys/block/#{disk}/queue/rotational"
  output = Facter::Util::FileRead.read(file)
  ssd_disks << disk if output.to_i == 0 && Facter.value("blockdevice_#{disk}_vendor") == 'ATA'
  hdd_disks << disk if output.to_i == 1 && Facter.value("blockdevice_#{disk}_vendor") == 'ATA'
  raid_disks << disk if Facter.value("blockdevice_#{disk}_vendor") =~ /^(SMC|LSI)$/
  multiple_queue_devices << disk if File.directory? "/sys/block/#{disk}/mq"
end

Facter.add('ssd') do
  confine :kernel => 'Linux'
  confine :id => :root

  setcode { ssd_disks.join(',') }
end unless ssd_disks.nil?

Facter.add('hdd') do
  confine :kernel => 'Linux'
  confine :id => :root

  setcode { hdd_disks.join(',') }
end unless hdd_disks.nil?

Facter.add('raid') do
  confine :kernel => 'Linux'
  confine :id => :root

  setcode { raid_disks.join(',') }
end unless raid_disks.nil?

Facter.add('multiple_queue_devices') do
  confine :kernel => 'Linux'
  confine :id => :root

  setcode { multiple_queue_devices.join(',') }
end unless multiple_queue_devices.nil?
