module Puppet::Parser::Functions
  newfunction(:dns_lookup, :type => :rvalue, :doc => <<-EOS
    EOS
  ) do |arguments|
    require 'resolv'

    host = arguments[0]
    record_type = (arguments[1] || 'A').upcase
    record_klass = "Resolv::DNS::Resource::IN::#{record_type}"
    record_type = record_klass.split('::').reduce(Object){|cls,c| cls.const_get(c)}

    results = Resolv::DNS.new.getresources(host, record_type).map do |record|
      record.address.to_s
    end
    raise Resolv::ResolvError, "no results for #{arguments[0]}" if results.empty?

    results
  end
end
