module Puppet::Parser::Functions
  newfunction(:hashify_array, :type => :rvalue, :doc => <<-EOS
    Takes an Array, and some arbitrary value
    returns  a Hash with every element in the Array as the key and value is value
    EOS
  ) do |arguments|

    keys = arguments[0]
    raise(Puppet::ParseError, "hashify_array(): first argument is not an Array " +
      "given (#{keys})") if not keys.kind_of? Array
    value = arguments[1]

    Hash[keys.map { |x| [x, value] }]
  end
end
