# class core::clearkernels
class core::clearkernels {
  $script = '/usr/local/bin/clearkernels'

  file { $script:
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/bin/clearkernels",
  }

  file { '/etc/kernel/postinst.d/apt-auto-removal':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/etc/kernel/postinst.d/apt-auto-removal.${lsbdistcodename}",
  }

  # new cronjob runs from root directly.
  cron::hourly { 'clean_old_kernels':
    user    => 'root',
    minute  => fqdn_rand(60, 'clean_old_kernels'),
    command => "${script} 2>&1 | logger -t clearkernels_cron -p local3.info",
    require => File[$script],
  }
}
