# class core::configs::ruby
class core::configs::ruby inherits core::configs {
  # TODO: get data out
  $rubygems_mirror = $core::params::twitch_mirrors['rubygems']

  file { '/etc/gemrc':
    content => template("${module_name}/gemrc.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
  }

  file { '/usr/local/etc/gemrc':
    ensure  => 'link',
    target  => '/etc/gemrc',
    require => File['/etc/gemrc']
  }

  # we need to make sure that gemrc gets put on the system BEFORE any gem package
  File['/etc/gemrc'] -> Package <| provider == 'gem' and tag != 'virtual' |>

}
