# define core::configs::user_configs
define core::configs::user_configs(
  $user         = $name,
  $default_home = '/home/users'
) {

  include core
  $pypi_mirror = $core::twitch_mirrors['pypi']

  # create default configs for users
  # root already exists, and so does
  $userdir = $user ? {
    'root'  => '/root',
    'jtv'   => '/home/jtv',
    default => "${default_home}/${user}"
  }

  validate_absolute_path($userdir)

  $file_source = "puppet:///modules/${module_name}"

  # we shouldn't be setting settings for users, ensuring absent
  file { "${userdir}/.vimrc":
    ensure => 'absent'
  }

  # pip unfortunately has to have a local config, so shared users
  # will need this (see https://github.com/pypa/pip/issues/309)
  file { "${userdir}/.pip":
    ensure => 'directory',
    owner  => $name,
    group  => $name
  }

  file { "${userdir}/.pip/pip.conf":
    content => template('core/pip.conf.erb'),
    owner   => $name,
    group   => $name,
    require => File["${userdir}/.pip"]
  }

  # this is overwritten via global distutils.cfg in twitch_python
  file { "${userdir}/.pydistutils.cfg":
    ensure => 'absent',
  }

  # we need this because some ruby clients dont respect the global one
  file { "${userdir}/.gemrc":
    ensure  => 'absent',
  }

}
