# Class to change the scaling governor of all CPUs
class core::cpu_scaling_governor(
  $scaling_governor = $core::params::cpu_scaling_governor,
) {
  validate_string($scaling_governor)

  include sysfs

  $cpuend = $facts["processorcount"] - 1
  $cpu_indexes = prefix(range(0, $cpuend), 'cpu')
  core::cpu_scaling_governor::cpu{$cpu_indexes:
    scaling_governor => $scaling_governor,
  }

  service { 'ondemand':
    ensure => stopped,
    enable => false,
  }

}
