# class core::dhcp
class core::dhcp (
  $enable_sns_hook = false,
) inherits core {
  # we remove this monstrosity of a package
  package { 'resolvconf':
    ensure => 'absent'
  }

  $dhclient_path = $::lsbdistcodename ? {
    'lucid' => '/etc/dhcp3',
    default => '/etc/dhcp',
  }

  $enter_hook_ensure = str2bool($core::use_local_resolver) ? {
    true    => 'present',
    default => 'absent',
  }

  # INC-479 files to ensure absent
  $inc_479_files = [
    '/usr/local/bin/ec2-azpref-resolvers',
    "${dhclient_path}/dhclient-exit-hooks.d/ec2-local-options",
    "${dhclient_path}/dhclient-exit-hooks.d/ec2-azpref-resolvers",
  ]
  file { $inc_479_files: ensure => 'absent' }
  exec { 'reinstall dhclient-script':
    command => 'apt-get install -y -qq --reinstall isc-dhcp-client',
    unless  => 'test -f /sbin/dhclient-script',
  }
  # END INC-479

  # if we use a local resolver, override any dns servers sent from DHCP, to be written into resolv.conf
  file { "${dhclient_path}/dhclient-enter-hooks.d/local-resolver":
    ensure  => $enter_hook_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "new_domain_name_servers=\"127.0.0.1\"\n",
  }

  # this file ensures we can send resolv.conf options via dhcp
  file { "${dhclient_path}/dhclient-exit-hooks.d/resolvoptions":
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/dhclient/resolvoptions"
  }

  if str2bool($enable_sns_hook) {
    include twitch_python::pip::awscli

    $_sns_hook_ensure = 'file'

    File["${dhclient_path}/dhclient-exit-hooks.d/10-sns-updater"] {
      require => Class['Twitch_python::Pip::Awscli'],
    }

    exec { 'sns-updater':
      command     => "/bin/sh ${dhclient_path}/dhclient-exit-hooks.d/10-sns-updater",
      subscribe   => File[
        "${dhclient_path}/dhclient-exit-hooks.d/10-sns-updater",
        '/usr/local/sbin/sns-updater.sh'
      ],
      refreshonly => true,
    }
  }
  else {
    $_sns_hook_ensure = 'absent'
  }

  file { "${dhclient_path}/dhclient-exit-hooks.d/10-sns-updater":
    ensure => $_sns_hook_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/dhclient/sns-updater-hook",
  }

  file { '/usr/local/sbin/sns-updater.sh':
    ensure => $_sns_hook_ensure,
    owner  => 'root',
    group  => 'root',
    mode   => '0744',
    source => "puppet:///modules/${module_name}/dhclient/sns-updater.sh",
  }
}
