# class core::fstrim
class core::fstrim {

  if str2bool($::systemd) {

    file { 'ensure /etc/cron.weekly/fstrim absent':
      ensure => 'absent',
      path   => '/etc/cron.weekly/fstrim'
    }

    twitch_systemd::unit_file { 'fstrim.service':
      ensure => 'present',
      source => 'puppet:///modules/core/fstrim.service'
    }

    twitch_systemd::unit_file { 'fstrim.timer':
      ensure => 'present',
      source => 'puppet:///modules/core/fstrim.timer'
    }

    service { 'fstrim.timer':
      ensure  => running,
      enable  => true,
      require => [ Twitch_systemd::Unit_file['fstrim.timer'], Twitch_systemd::Unit_file['fstrim.service'] ]
    }
  }

}
