# class gore::grub
class core::grub {

  # TODO: redo all the things here
  # precise and lucid use grub2, we shouldn't care about older versions
  # too many execs here to decouple, should be replaced with templates
  if $::lsbmajdistrelease >= '10' {
    # TODO: replace with file resource???
    # /etc/default/grub
    #file { '/etc/default/grub':
    #  content => template("${module_name}/grub/grub2.default.erb"),
    #  owner   => 'root',
    #  group   => 'root',
    #  mode    => 0644
    #}
    $update_grub_cmd = '/usr/sbin/update-grub'

    exec { 'display_grub_menu_via_serial':
      command => 'sed -i "/^GRUB_HIDDEN_TIMEOUT/s|^|#|" /etc/default/grub',
      onlyif  => 'grep ^GRUB_HIDDEN_TIMEOUT /etc/default/grub',
      notify  => Exec['update-grub']
    }
    exec { 'replace_splash':
      command => 'sed -i "/splash/s|||" /etc/default/grub',
      onlyif  => "grep 'splash' /etc/default/grub",
      notify  => Exec['update-grub']
    }
    exec { 'replace_quiet':
      command => 'sed -i "/quiet/s|||" /etc/default/grub',
      onlyif  => 'grep \'quiet\' /etc/default/grub',
      notify  => Exec['update-grub']
    }
  } else {
    # here for legacy reasons... it can likely be removed
    $update_grub_cmd = '/usr/sbin/update-grub -y'
  }

  $cmd = $::lsbdistcodename ? {
    lucid   => 'sed -i "/^MODULES/s|=dep|=most|" /etc/initramfs-tools/initramfs.conf',
    default => 'sed -i "/^MODULES/s|=most|=dep|" /etc/initramfs-tools/initramfs.conf',
  }

  $check = $::lsbdistcodename ? {
    lucid   => 'grep -v ^MODULES=most /etc/initramfs-tools/initramfs.conf',
    default => 'grep ^MODULES=most /etc/initramfs-tools/initramfs.conf'
  }

  exec { 'targeted_initrd':
    command => $cmd,
    onlyif  => $check,
    notify  => Exec['update-grub']
  }

  case $facts['lsbdistcodename'] {
    'trusty': {
      file { '/etc/grub.d/00_header':
        source => "puppet:///modules/${module_name}/trusty-00_header",
        owner  => 'root',
        group  => 'root',
        mode   => '0755',
        notify => Exec['update-grub']
      }
    }
    default: {}
  }

  exec { 'update-grub':
    command     => $update_grub_cmd,
    refreshonly => true,
  }
}
