# class core::hardware
class core::hardware {

  $hardware_only_packages = [
    'dmidecode',
  ]

  include twitch_dkms


  if str2bool($::systemd) {

    twitch_systemd::drop_in { 'logind.conf':
      unit    => 'logind.conf',
      path    => '/etc/systemd',
      content => template("${module_name}/systemd/logind.conf.erb"),
      notify  => Service['systemd-logind'],
    }

    service { 'systemd-logind':
      ensure =>  running
    }

  }

  package { $hardware_only_packages:
    ensure => 'installed',
  }

  package { 'ipmicfg':
    ensure => purged,
  }

  if str2bool($::hwraid) {
    $ensure =  'present'
  } else {
    $ensure = 'absent'
  }

  # Install megacli if node has hardware raid
  package { 'megacli':
    ensure => $ensure,
  }
}
