# make sure we have our own hostname.domain set in /etc/hosts
class core::hosts {

  host { "${::hostname}.${::domain}":
    ensure       => present,
    ip           => '127.0.1.1',
    host_aliases => $::hostname,
    before       => Class['core::packages'],
  }

  host { "${::hostname}.":
    ensure       => absent,
    ip           => '127.0.1.1',
    host_aliases => $::hostname,
    before       => Class['core::packages'],
  }

}
