# core
#
# the main core of ALL the systems.
# everything in here is supposed to be on
#
#  EVERY BOX across EVERY ENVIRONMENT
#
# please edit with caution
class core (
  $twitch_nameservers = $core::params::twitch_nameservers,
  $searchdomain       = $core::params::twitch_searchdomain,
  $use_mainline_lts   = $core::params::use_mainline_lts,
  $use_local_resolver = $core::params::use_local_resolver,
  $disable_ganglia    = $core::params::disable_ganglia,
  $default_dir        = $core::params::default_dir,
) inherits core::params {

  validate_array($twitch_nameservers)
  validate_bool($use_mainline_lts)
  validate_string($searchdomain)
  # rotate params based on fqdn
  # can be used elsewhere
  # TODO: remove, we actually rely on DHCP to set the DNS servers properly
  $nameservers = fqdn_rotate($twitch_nameservers)

  # Print EOL of message
  if $::core::eol_message != undef {
    notify { 'END OF LIFE MESSAGE':
      message => $::core::eol_message
    }
  }

  # Log the puppetmaster the client is connecting to
  notify { 'identify_puppetmaster_message':
    message => "This client, ${::twitch_uuid}::${::fqdn}, is connecting to ${::servername}",
  }
  notify { 'identify_puppet_role':
    message => "Cluster: ${cluster}, Role: ${::twitch_role}, Node Env: ${twitch_environment}, Fact Env: ${::twitch_environment}",
  }

  # Determine the correct package class
  $package_class = $facts['osfamily'] ? {
    'RedHat' => 'core::yum',
    'Debian' => 'twitch_apt',
  }

  # Use twitch_core for centos/amazon linux
  # Eventually for everything
  if ( $facts['osfamily'] == 'RedHat') {
    include twitch_core
  } else {

    #Enable internal repos for apt/yum
    include $package_class
    include core::configs
    include core::dns
    include core::hosts
    include core::packages
    include core::profile
    include core::sysctl
    include core::filebeat
    include core::cpu_scaling_governor
    include core::fstrim
    include core::profile_d

    # these things are excluded from vagrant
    # but included everywhere else
    if ($::vagrant == undef) {
      # exclude linkagg from EC2 hosts
      if ($::ec2_metadata == undef) {
        include twitch_link_aggregation
      }
      include core::clearkernels
      class { 'core::unscd':
        ensure => 'absent',
      }
      include core::grub

      include core::serial_console
      include twitch_diamond
    }

    # We will clean this up at some point in the future,
    # but for now, this makes sure ganglia is disabled
    include twitch_ganglia::disabled

    if $::virtual == 'physical' {
      include core::hardware
      include twitch_link_aggregation
    }

    # external modules in core
    include cron
    include cgroups
    include consul
    include courier
    include daemontools
    include mcelog
    include twitch_monit
    include sysfs
    include sysstat
    include twitch_dirs
    include twitch_disktune
    include twitch_useraccess
    include twitch::users::common
    include twitch_python
    include twitch_syslog::central_syslog
    include twitch_smtp
    include twitch_nrpe
    include unattended_upgrades
    include twitch_ipv6
    include twitch_timesyncd
    include video_tools_envfile
    include twitch_motd

    if versioncmp($::lsbmajdistrelease, '18.04') >= 0 {
      $augeas_ensure = absent
    } else {
      $augeas_ensure = present
    }

    $gpg_requires_proxy = str2bool($::proxy_needed) ? {
      true    => "http-proxy=${::twitch_proxy_config::http_proxy}",
      default => undef,
    }

    anchor {'core::kmod_augeas::begin': }
    -> apt::source {'augeas':
      ensure   => $augeas_ensure,
      location => 'http://ppa.launchpad.net/raphink/augeas/ubuntu',
      release  =>  $::lsbdistcodename,
      repos    =>  'main',
      key      =>  {
        id      =>  'CF6D4DF76A7B62DDCE6C3D99EEDBF1C2AE498453',
        options =>  $gpg_requires_proxy,
        },
    }
    -> class {'::augeas':
      version      => latest,
      ruby_version => latest,
    }
    # blacklist overlayfs to close CVE-2015-1328
    # Add overlayfs to modprobe blacklist
    -> kmod::blacklist { 'overlayfs': }
    # Forcibly prevent the module from being loaded
    -> kmod::install { 'overlayfs': command => '/bin/false' }

    # block unused filesystem modules
    -> kmod::blacklist { $::core::kmod_blacklist_filesystems: }

    # Migrated from core::modprobe
    -> kmod::blacklist { 'vga16fb': }
    -> kmod::blacklist { 'radeon': }
    -> file { '/etc/modprobe.d/blacklist-jtv.conf':
      ensure => 'absent',
    }
    -> anchor {'core::kmod_augeas::end': }
  }
}
