#class core::packages
class core::packages {
  # TODO: remove here until we can include all of
  # twitch module at a higher level
  include twitch::packages
  include core::git
  include wget
  include ethtool
  include netcat
  include openssl

  # some modules like to install this first, so we need to do if !defined()
  if !defined(Package['apt-transport-https']) {
    package { 'apt-transport-https':
      ensure => present
    }
  }

  # define packages to install everywhere
  # includes bare metal, vagrant, docker, etc.
  $installed_packages = [
    'bsd-mailx',  # mail user agent
    'bzip2',
    'debian-archive-keyring',
    'debian-keyring',
    'man-db',
    'libldap-2.4-2',
  ]

  @package { [
      'curl',
      'libcurl3',
      'libcurl3-gnutls',
      'libcurl4-openssl-dev'
    ]:
      ensure  => present,
      tag     => 'virtual',
      require => Exec['apt_update'],
  }

  # these are packages we expect to be available when debugging issues in
  # production. vagrant doesn't need these packages.
  $production_packages = [
    'bind9-host',      # provides the 'host' command
    'debian-goodies',  # Small toolbox-style utilities for Debian systems
    'dnsutils',        # provides the 'dig' command
    'dstat',           # replacement for vmstat
    'htop',
    'ifstat',
    'iotop',
    'iperf',
    'iptraf',
    'lsof',
    'memtest86+',
    'mosh',
    'mtr-tiny',
    'nmap',
    'psmisc',
    'pv',
    'smartmontools',
    'strace',
    'tcpdump',
    'tcpstat',
    'telnet',
    'traceroute',
    'whois',
  ]

  # additional text editors to be installed in production
  # vim is included everywhere by default
  if versioncmp($::lsbmajdistrelease, '15.04') >= 0 {
    $emacs_package = 'emacs-nox'
  } else {
    $emacs_package = 'emacs23-nox'
  }

  $editor_packages = [
    $emacs_package,
    'joe',
    'nano',
  ]

  # these packages get installed on bare metal servers only
  # not sure where these are used yet
  $other_packages = [
    'expect',
  ]

  # install global packages
  package { $installed_packages: ensure  => 'installed' }
  package { 'pbzip2': ensure => latest }
  realize(Package['build-essential'])  # defined in twitch::packages
  realize(Package['screen'])
  realize(Package['curl'])

  # install hardware-only packages
  # we should add docker to the list of exclusions
  # to do: classify these things more appropriately via Hiera
  if ($::vagrant == undef) {
    package { $production_packages:    ensure => installed }
    package { $other_packages:         ensure => installed }
    package { $editor_packages:        ensure => installed }

    include twitch_irqbalance

    # set the default editor to vim (to override joe)
    alternatives { 'editor':
      path    => '/usr/bin/vim.basic',
      require => Package[$editor_packages],
    }

    # these packages are in twitch::packages for any to realize
    # we need them in core so we realize them here
    realize(Package['libssl-dev'])
  }
}
