# params that go here are global to the core
class core::params {
  $host_formatted           = regsubst($::fqdn, '\.', '-', 'G')

  $disable_ganglia      = true
  # installs the 4.1 mainline lts when set to true
  $use_mainline_lts    = false

  $twitch_nameservers  = hiera('twitch_nameservers')
  $twitch_searchdomain = 'justin.tv'

  $twitch_mirror_key = hiera('twitch_mirror_key')

  $twitch_mirrors = {
    'pypi'               => hiera('pypi_mirror'),
    'rubygems'           => hiera('rubygems_mirror'),
    'ubuntu'             => hiera('apt_mirror'),
    'twitch'             => hiera('twitch_mirror'),
    'twitch_apt_gpg_key' => hiera('twitch_apt_gpg_key'),
  }

  # password for nagios passive checks
  $nsca_password = 'R8rMzgKCuAvFKfD'

  case $::osfamily {
    'RedHat': {
      $default_dir = '/etc/sysconfig'
    }
    'Debian': {
      $default_dir = '/etc/default'
    }
    default: {
      warning("${::osfamily} might not be fully supported.")
      warning('The supported OS Families are Debian and RedHat.')
      warning('There is no guarantee that everything will work.')
      warning('Please contact #puppet for assistance')
    }
  }

  $use_local_resolver = false

  $cpu_scaling_governor = 'ondemand'

  $eol_message = $::lsbdistcodename ? {
    'precise' => "\n\n${::operatingsystem} ${::operatingsystemrelease} LTS (${::lsbdistcodename}) will reach EOL on April 2017.\nUbuntu will discontinue maintenance updates, including critical security upgrades.\n\nWe highly recommend that you upgrade to the latest Ubuntu LTS version.\n\n",
    default => undef
  }

  $kmod_blacklist_filesystems = ['btrfs', 'hfs', 'hfsplus', 'jfs', 'minix', 'ntfs', 'qnx4', 'ufs']

}
