# class core::serial_console
class core::serial_console {

  if versioncmp($::lsbmajdistrelease, '15.04') < 0 {
    $serial_ensure = 'present'
  } else {
    $serial_ensure = 'absent'
  }

  # configures serial consoles for various hardware types
  $speed = '115200' # default baudrate for all
  case $::manufacturer {
    'Supermicro', 'iXsystems': {
      $ttyserial = 'ttyS1'
    }
    /^Rack(able|live)/: {
      $ttyserial = 'ttyS1'
    }
    default: {
      # Default for: Dell, Bochs (libvirt)
      $ttyserial = 'ttyS0'
    }
  }

  file { "/etc/init/${ttyserial}.conf":
    ensure  => $serial_ensure,
    content => template("${module_name}/serial_console.init.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
  }

}
