# class core::unscd
class core::unscd (
  $ensure = 'present'
) {

  validate_re($ensure, '^(present|absent)$')

  package { 'unscd':
    ensure => $ensure,
  }

  file { '/etc/nscd.conf':
    ensure  => $ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/core/nscd.conf',
    notify  => Service['unscd'],
    require => Package['unscd'],
  }

  $service_ensure = $ensure ? {
    'present' => 'running',
    default   => 'stopped'
  }

  $service_enable = $ensure ? {
    'present' => true,
    default   => false
  }

  service { 'unscd':
    ensure => $service_ensure,
    enable => $service_enable,
  }

}
