# core::util::debconf
define core::util::debconf(
  $package,
  $key,
  $type,
  $value
) {
  include twitch::packages
  realize(Package['debconf-utils'])
  $debconf_string = "${package}\t${key}\t${type}\t${value}"
  exec { "debconf_${package}_${key}":
    command => "echo ${debconf_string} | debconf-set-selections",
    unless  => "debconf-get-selections | grep -E '^${debconf_string}'",
    require => Package['debconf-utils'],
  }
}
