# Configures yum mirrors
#
class core::yum {
  # deprecated systems-yum repo, delete.
  yumrepo { 'twitch-systems': ensure => absent }

  if $facts['operatingsystem'] == 'Amazon' {
    # Install ALinux repos
    yumrepo { 'artifactory':
      baseurl      => 'https://rpm.internal.justin.tv/amzn/$releasever',
      enabled      => 1,
      gpgcheck     => 0,
      http_caching => 'none',
      descr        => 'Twitch Artifactory ALinux',
    }
  } else {
    yumrepo { 'twitch-video':
      baseurl      => 'http://twitch-video-yum-repo.s3-website-us-west-2.amazonaws.com/',
      enabled      => 1,
      gpgcheck     => 0,
      http_caching => 'none',
      descr        => 'Twitch Video El 7 - $basearch',
    }
    # Centos 7 artifactory
    yumrepo { 'artifactory':
      baseurl      => 'https://rpm.internal.justin.tv/centos7',
      enabled      => 1,
      gpgcheck     => 0,
      http_caching => 'none',
      descr        => 'Twitch Artifactory El 7',
    }
    Yumrepo <| |> -> Package <| provider != 'rpm' |>
  }
}
