require 'spec_helper'

hiera_file = 'spec/fixtures/hiera/hiera.yaml'

describe 'core::dirs', :type => :class do
  let(:facts) do {
    :osfamily => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress => '127.0.0.1'
  }
  end
  let(:hiera_config) { hiera_file }
  hiera = Hiera.new(:config => hiera_file)
  lookup = hiera.lookup('twitch_basedir',nil,nil)
  let(:twitch_basedir) { lookup }

  let(:resource_count) { 3 }

  it 'does compile' do
    should compile.with_all_deps
  end

  it "does contain #{:resource_number} resources" do
    should have_resource_count(resource_count)
  end

  it 'does have_class_count of 1' do
    should have_class_count(1)
  end

  context 'verify core::dirs' do
    it 'does contain /var/chroot' do
      should contain_file('/var/chroot').with({
        :ensure => 'directory',
        :owner  => 'root',
        :group  => 'root',
        :mode   => '0755',
      })
    end

    it 'does contain /opt' do
      should contain_file('/opt').with({
        :ensure => 'directory',
        :owner  => 'root',
        :group  => 'root',
        :mode   => '0755',
      })
    end

    it "does contain /opt/booyah" do
      should contain_file(twitch_basedir).with({
        :ensure => 'directory',
        :owner  => 'root',
        :group  => 'root',
      })
    end
  end
end
