class courierd::config (
  $courierd_config = '/etc/courierd.conf',
) {
  include courierd

  validate_absolute_path($courierd_config)

  $user    = $courierd::user
  $version = $courierd::version

  $clean = hiera('clean', 'false')
  $config_mode = '0440'

  $ensure_resource = $version ? {
    'absent' => absent,
    default  => present,
  }

  concat{ $courierd_config:
    ensure => $ensure_resource,
    owner  => $user,
    group  => '0',
    mode   => $config_mode,
    notify => Service['courierd'],
  }

  # In case no paths are added, we want concat to not error
  concat::fragment { 'placeholder':
    target    => $courierd_config,
    order    => '01',
    content => "\n",
  }
}
