Puppet::Type.type(:service).provide :twitch_daemontools, :parent => :daemontools do
  desc <<-'EOT'
    Twitch Daemontools service management.

    Enables :restart override for daemontools service provider

    we can provide restart command override for any signal
    man svc:
      -p     Pause. Send the service a STOP signal.
      -c     Continue. Send the service a CONT signal.
      -h     Hangup. Send the service a HUP signal.
      -a     Alarm. Send the service an ALRM signal.
      -i     Interrupt. Send the service an INT signal.
  EOT

  def restart
    signal_map = {
      'STOP' => '-p',
      'CONT' => '-c',
      'HUP' => '-h',
      'ALRM' => '-a',
      'INT' => '-i',
    }

    if @resource[:restart].nil? or @resource[:restart] == 'TERM'
      super
    elsif signal_map.keys.include?(@resource[:restart])
      svc signal_map[@resource[:restart]], self.service
    else
      raise Puppet::Error,
        "Twitch_Daemontools signal #{@resource[:restart]} is not supported"
    end
  end

  # returns current status of daemon :running or :stopped
  # we have a special case when we have a manual down file in the daemon dir
  # if we have a downfile, we want it down regardless, so we actually
  # set :ensure => :stopped on the resource, such that puppet doesn't try to
  # start it
  def status
    downfile = File.join(self.daemon, 'down')
    if FileTest.exists?(downfile) and not @resource[:ensure] == :stopped
      Puppet.notice "Service[#{@resource[:name]}]: #{downfile} exists! Ensuring service is stopped (catalog wants: #{@resource[:ensure]})."
      # HACK: we're transparently changing the desired state (possibly against what the catalog wants)
      @resource[:ensure] = :stopped
    end
    super
  end

end
