define daemontools::envdir (
  $key_name = $name,
  $base_dir = undef,
  $value    = undef,
  $unset    = false,
) {
  validate_absolute_path($base_dir)

  if $value != undef and !$unset {
    if $unset {
      # if we are unsetting the variable it needs to be 0 bytes long:
      $content = ""
    } else {
      # Add a newline to make cat work nicely:
      $content = "$value\n"
    }

    file { "$base_dir/$key_name":
      mode    => '0444',
      content => $content,
    }
  }
}
