class daemontools inherits daemontools::params {

  require ::twitch_syslog

  package { $packages: }

  service { $daemontools_name:
    ensure   => 'running',
    enable   => true,
    require  => Package[$packages],
    provider => $daemontools_provider,
  }

  file { $daemon_dirs:
    ensure  => 'directory',
    require => Package[$packages]
  }

  # helper script to remove services
  file { "/usr/local/bin/remove_service":
    source => "puppet:///modules/${module_name}/remove_service",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

}
