class discovery::haproxy::backend_discovery_database_master_production (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-discovery-master',
  $servers        = [
    'discovery-production-master-0.production.twitch-web-aws.us-west2.justin.tv',
  ],
  $listen_port    = 12150,
  $remote_port    = 5432,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
