require 'spec_helper'

describe 'discovery', :type => :class do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:params) do {
      :discovery_basedir     => '/tmp/discovery',
      :discovery_environment => 'spec-test',
      :user                  => 'test',
      :port                  => 1111,
    }
    end

    it 'does include nginx vhost' do
      should contain_nginx__vhost('godiscovery')
    end

    it 'does include haproxy backend' do
      should contain_class('twitch::haproxy::backend')
    end

    it 'does register to consul as discovery' do
      should contain_consul__service('discovery').with({
        :port        => params[:port],
        :consul_tags => [params[:discovery_environment]],
      })
    end

    it "does contain file Daemontools::Supervise['discovery']" do
      should contain_daemontools__supervise('discovery').with({
        :wd      => params[:discovery_basedir],
        :user    => params[:user],
        :options => "-addr :#{params[:port]}",
      })
    end
  end
end
