# the guts of each cluster instance.
define dumbo_wireguard::cluster (
  $ensure       = 'running',
  $owner_key    = 'video-offnet',
  $environment  = $::wireguard::params::environment,
  $service_name = 'wireguard-netrr',
  $cluster      = $name,
  $listen_port  = 11211,
  $keepalive    = 30,
  $wg_interface = ['wg0', '169.254.0.1', 29 ],
  $local_asn    = 46489,
  $peer_asn     = undef,
  $allow_asn    = undef,
  $peer_pref    = undef,
  $peers        = undef,
  $prefix_limit = undef,
) {

  include dumbo_wireguard

  $ifname = $wg_interface[0]
  $ifaddr = $wg_interface[1]
  $ifmask = $wg_interface[2]

  notify { "cluster ${name}:": message => "configuring interface ${ifname}" }

  $ensure_file = $ensure ? {
    absent  => absent,
    default => present,
  }

  twitch_sandstorm_agent::template { "${ifname}.conf":
    ensure          => $ensure_file,
    destination     => "/etc/wireguard/${ifname}.conf",
    restart_command => "systemctl restart wireguard@${ifname}",
    contents        => template('dumbo_wireguard/config.erb'),
  }

  file { "${ifname}-env.conf":
    ensure  => $ensure_file,
    path    => "/etc/systemd/system/wireguard@.service.d/${ifname}-env.conf",
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('dumbo_wireguard/env.erb'),
  }


  $enable = $ensure ? {
    'absent' => false,
    default  => true,
  }

  service { "wireguard@${ifname}.service":
    ensure  => $ensure,
    enable  => $enable,
    require => [ Twitch_sandstorm_agent::Template["${ifname}.conf"], File["${ifname}-env.conf"] ],
    notify  => Exec["${ifname}-daemon-reload"],
  }

  exec { "${ifname}-daemon-reload":
    command     => 'systemctl daemon-reload',
    refreshonly => true,
  }

}
