# The wireguard::tunnel resource creates a wireguard interface with given
# private key, listen port and peer list. This is done by adding a
# configuration file inside /etc/wireguard, and enabling and starting the
# wireguard@ service, installed by wireguard::packages.
#
# @param private_key the private key used here
# @param listen_port on which port wireguard should listen for incoming
# connections.  Chosen randomly if not specified.
# @param: a list of peers with a dict containing public_key (mandatory),
# allowed_ips and endpoint (optional). See wireguard::simple_tunnel for a
# detailed description.

define dumbo_wireguard::tunnel (
  $private_key,
  $listen_port,
  $ensure = 'present',
  $peers = {},
) {

  include ::dumbo_wireguard

  file { "/etc/wireguard/${title}.conf":
    ensure  => $ensure,
    content => template('wireguard/config.erb'),
    notify  => Service["wireguard@${title}.service"],
  }

  $enable = $ensure ? {
    'absent' => false,
    default  => true,
  }

  $ensure_svc = $ensure ? {
    'absent' => 'stopped',
    default  => 'running',
  }

  service { "wireguard@${title}.service":
    ensure  => $ensure_svc,
    enable  => $enable,
    require => File["/etc/wireguard/${title}.conf"],
  }
}
