# Edgecast Stats Service
#
# External service running on video-daemons host used to update
# usher with edgecast hose bandwidths.
class edgecast_stats (
  $ensure      = 'present',
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary      = false,
  $svcname     = 'edgecast_stats',
  $user        = 'nobody',
  $updateusher = true,
  $concurrency = 0
) {
  file { "/opt/twitch/${svcname}/etc/${svcname}.conf.json":
    ensure  => $ensure,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0644',
    content => template('edgecast_stats/edgecast_stats.conf.json')
  }

  if ! $updateusher {
    $noop_flag = '--noop'
  }

  $daemon = "${lsbdistcodename}/run --config_file=/opt/twitch/${svcname}/etc/${svcname}.conf.json"

  twitch::service { 'edgecast_stats' :
    ensure         => $ensure,
    env            => $env,
    canary         => $canary,
    manage_service => true,
    daemon_cmd     => "${daemon} ${noop_flag}",
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo   => 'video/edgecast_stats',
    user           => $user,
    concurrency    => $concurrency
  }
}
