class edgeeventproxy (
  $env            = pick($::twitch_environment, $twitch_environment, 'production'),
  $eeproxy_enable = true,
  $canary         = false,
  $node           = $::pqdn,
  $node_type      = undef,
  $type           = undef,
  $statsd_rate    = 0.1
)
{
  validate_bool($eeproxy_enable)
  validate_re($node_type, ['^edge$', '^weaver$'])
  validate_re($type, ['^server$', '^client$'])
  $eeproxy_ensure = $eeproxy_enable ? {
    true  => 'present',
    false => 'absent',
  }

  twitch::service {'edgeeventproxy':
    env                => $env,
    canary             => $canary,
    daemon_cmd         => "./edgeeventproxy -node=${node} -${type} -statsd-prefix=\"video.${node_type}.edgeevent.${::pop}\" -sample-rate=${statsd_rate}",
    predaemon          => [
      'exec 2>&1',
      'mkdir -p /var/run/edgeeventproxy',
      'chown -R nobody: /var/run/edgeeventproxy'
    ],
    service_repo       => 'video/edgeeventproxy',
    user               => 'nobody',
    daemontools_ensure => $eeproxy_ensure,
    manage_service     => true
  }
}
