#!/usr/bin/ruby
require 'open-uri'

def find_ebs_volumes()
  symbol = "ec2_ebs_present"
  value = "False"
  begin
    open("http://169.254.169.254/latest/meta-data/block-device-mapping/") { |f|
      f.each_line { |line|
        if line.include? 'ebs'
          value = "True"
        end
      }
    }
  rescue Exception
  end
  Facter.add(symbol) { setcode { value } }
end

if ! Facter.value('ec2_instance_id').nil?
  find_ebs_volumes
else
  Facter.debug "Not an EC2 host"
end
