#!/usr/bin/ruby
require "json"
require "open-uri"

def parse_json(userData)
    # This code turns JSON values into facts, but strictly requires valid JSON!
    JSON.parse(userData.dup).each do |array|
        key = array[0].dup
        key.insert(0, "ec2_user_data_")
        val = array[1].dup
        Facter.add(key) { setcode { val } }
    end
end

def get_user_data()
    begin
        # query ec2 for user-data
        userData = open("http://169.254.169.254/latest/user-data").read()

        # attempt to parse json
        begin
            parse_json userData

        # return the full string if that fails
        rescue
            Facter.add("ec2_user_data_string") { setcode { userData } }
        end

    rescue OpenURI::HTTPError
        Facter.debug "No user-data associated with this host"
    rescue Exception
        Facter.debug "No user-data associated with this host -- this might not even be EC2 (Exception)"
    end
end

if ! Facter.value('ec2_instance_id').nil?
    get_user_data
else
    Facter.debug "Not an EC2 host"
end
