# Find all physical devices with a link
Facter.add('interfaces_with_link') do
  confine :kernel => 'Linux'
  confine :is_virtual => false

  setcode do
    interfaces = Array.new
    Dir.glob("/sys/class/net/*").each do |intf_dir|
      if File.symlink?("#{intf_dir}/device")
        begin
          if File.read("#{intf_dir}/carrier").chomp == "1"
            interfaces << File.basename(intf_dir)
          end
        rescue Errno::EINVAL
          # reading from carrier file can result in "Invalid Argument" error
        end
      end
    end
    interfaces.join(",")
  end
end
