interfaces = Facter.value(:interfaces)
ipaddresses_hash = {}

interfaces.split(',').each do |i|
  ipaddress = Facter.value("ipaddress_#{i}")
  if ipaddress
    interface_key = i.gsub(/_.*$/,'')
    if !ipaddresses_hash[interface_key]
      ipaddresses_hash[interface_key] = []
    end
    ipaddresses_hash[interface_key] << ipaddress
  end
  if ipaddresses_hash[interface_key]
    Facter.add("ipaddresses_" + interface_key) do
      setcode { ipaddresses_hash[interface_key].join(",") }
    end
  end
end
