#!/usr/bin/ruby
# sets fact machine_type to baremetal, ec2, or other as determined below
#
# Things used to test machinetype:
# $::vagrant == undef
# $::ec2_metadata == undef (or $::ec2_instance_id for puppet3, or more accurate for p5: $::ec2_metadata['instance_id']
# $::cmdline['boot'] == 'live' (relies on cmdline fact, which parses string data from a proc file
# $::virtual == 'physical' (this fact also returns 'kvm' and maybe other values?
# $::packer_build_name == undef
#
# Types of things we want this fact to check for and return as an answer:
# ec2                 "An EC2 host"
# netboot_build       "A virtual machine building a netboot image" 
# baremetal           "A physical machine that doesn't meet any other criteria"
# baremetal_netboot   "A physical machine booted via netboot image"
# vagrant             "A vagrant instance not meeting other criteria"
# $::virtual          "other virtual machine/container not meeting other criteria (so we return $::virtual)"
#
if Facter.value(:virtual) == 'physical'
  if Facter.value(:cmdline).key?('boot') and Facter.value(:cmdline)['boot'] == 'live'
    Facter.add("machine_type") { setcode { 'baremetal_netboot' } }
  else
    Facter.add("machine_type") { setcode { 'baremetal' } }
  end
else
  if ! Facter.value(:vagrant).nil?
    if ! Facter.value(:packer_build_name).nil?
      Facter.add("machine_type") { setcode { 'netboot_build' } }
    else
      Facter.add("machine_type") { setcode { 'vagrant' } }
    end
  else
    if !Facter.value(:ec2_instance_id).nil? or (Facter.value(:ec2_metadata).key?('instance-id') and !Facter.value(:ec2_metadata)['instance-id'].empty?)
      Facter.add("machine_type") { setcode { 'ec2' } }
    else
      # Default virtual: return the value of the $::virtual fact
      Facter.add("machine_type") { setcode { Facter.value(:virtual) } }
    end
  end
end
